/*
 * Die Sourcecodes, die diesem Buch als Beispiele beiliegen, sind
 * Copyright (c) 2006 - Thomas Ekert. Alle Rechte vorbehalten.
 * 
 * Trotz sorgfltiger Kontrolle sind Fehler in Softwareprodukten nie vollstndig auszuschlieen.
 * Die Sourcodes werden in Ihrem Originalzustand ausgeliefert.
 * Ansprche auf Anpassung, Weiterentwicklung, Fehlerbehebung, Support
 * oder sonstige wie auch immer gearteten Leistungen oder Haftung sind ausgeschlossen.
 * Sie drfen kommerziell genutzt, weiterverarbeitet oder weitervertrieben werden.
 * Voraussetzung hierfr ist, dass fr jeden beteiligten Entwickler, jeweils mindestens
 * ein Exemplar dieses Buches in seiner aktuellen Version als gekauftes Exemplar vorliegt.
 */
package djbuch.kapitel_11; import djbuch.kapitel_06.DemoTools;
import djbuch.kapitel_06.GC;
import lotus.domino.*;

/**
 * Zeigt den programmatischen Aufbau einer Domino RichText Tabelle und deren Export
 * @author Thomas Ekert
 */
public class RichTextTableDemo extends NotesThread {
	private static final String PASSWORD = "geheim";
	private static final String HOST = null;//"www.djbuch.de"; 		//null fr lokale Session
	private static final String USER = null;//"Thomas Ekert/DJBUCH";	//null fr lokale Session

	public static void main(String[] args) {
		RichTextTableDemo rtd = new RichTextTableDemo();
		rtd.start();
	}
	public void runNotes() {
		Document doc = null; Database db = null;
		Session session = null; RichTextItem rti = null;
		try {
			session = NotesFactory.createSession(HOST, USER, PASSWORD);
			db = session.getDatabase("", "djbuch/djbuch.nsf");
			doc = DemoTools.createDoc(db,"FO_dokumentRT_k11","Wombat","Ich beinhalte RichText", null);
			rti = doc.createRichTextItem("body");
			String basePath = System.getProperty("user.dir") + "/src/djbuch/kapitel_11/";
			basePath = DemoTools.replaceSubstring(basePath,"\\","/");
			rti.appendText("Tabelle aus Excel (" + basePath+"demo.xls)"); rti.addNewLine();
			ExcelToRichTextConverter etri = new ExcelToRichTextConverter (rti, basePath+"demo.xls");
			etri.runImport();
			doc.save (true,false);
			String unid = doc.getUniversalID();
			GC.recycle(rti); GC.recycle(doc);
			doc = db.getDocumentByUNID(unid);
			rti = (RichTextItem) doc.getFirstItem("body");
			etri = new ExcelToRichTextConverter (rti, basePath+"out.xls");
			etri.runExport(1);
			doc.save (true,false);
			GC.recycle (doc);
		} catch (Exception e) {
			e.printStackTrace();
			System.err.println ((e instanceof NotesException?"id = " +((NotesException)e).id:""));
		} finally {
			GC.recycle (rti); GC.recycle(doc); GC.recycle(db); GC.recycle(session);
		}
	}
}
